const express = require("express");
const router = express.Router();
const ClientTwitter = require("../../models/sales_chanels/clientTwitter");
const auth = require("../../middleware/auth");

// 🟢 Create a new Twitter client
router.post("/client/channel/twitter/create", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    if (!client_id || typeof client_id !== "number") {
      return res
        .status(400)
        .json({ error: "client_id must be a valid integer" });
    }

    const newClientId = await ClientTwitter.create(req.body);
    res
      .status(201)
      .json({ message: "Client created successfully", client_id: newClientId });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get all Twitter clients
router.get("/client/channel/twitter/all", auth, async (req, res) => {
  try {
    const clients = await ClientTwitter.getAll();
    res.status(200).json(clients);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get a Twitter client by ID
router.get("/client/channel/twitter/:id", auth, async (req, res) => {
  try {
    const client_id = parseInt(req.params.id);
    if (isNaN(client_id)) {
      return res.status(400).json({ error: "Invalid client_id" });
    }

    const client = await ClientTwitter.getById(client_id);
    if (!client) return res.status(404).json({ error: "Client not found" });

    res.status(200).json(client);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Update a Twitter client
router.put("/client/channel/twitter/update", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    if (!client_id || typeof client_id !== "number") {
      return res
        .status(400)
        .json({ error: "client_id must be a valid integer" });
    }

    const updatedClientId = await ClientTwitter.update(req.body);
    res.status(200).json({
      message: "Client updated successfully",
      client_id: updatedClientId,
    });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Delete a Twitter client
router.delete("/client/channel/twitter/:id", auth, async (req, res) => {
  try {
    const client_id = parseInt(req.params.id);
    if (isNaN(client_id)) {
      return res.status(400).json({ error: "Invalid client_id" });
    }

    await ClientTwitter.delete(client_id);
    res.status(200).json({ message: "Client deleted successfully" });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

module.exports = router;
