const express = require("express");
const router = express.Router();
const ClientLinkedIn = require("../../models/sales_chanels/clientLinkedin");
const auth = require("../../middleware/auth");

// 🟢 Create a new LinkedIn client
router.post("/client/channel/linkedin/create", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    if (!client_id || typeof client_id !== "number") {
      return res
        .status(400)
        .json({ error: "client_id must be a valid integer" });
    }

    const newClientId = await ClientLinkedIn.create(req.body);
    res
      .status(201)
      .json({ message: "Client created successfully", client_id: newClientId });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get all LinkedIn clients
router.get("/client/channel/linkedin/all", auth, async (req, res) => {
  try {
    const clients = await ClientLinkedIn.getAll();
    res.status(200).json(clients);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get a LinkedIn client by ID
router.get("/client/channel/linkedin/:id", auth, async (req, res) => {
  try {
    const client_id = parseInt(req.params.id);
    if (isNaN(client_id)) {
      return res.status(400).json({ error: "Invalid client_id" });
    }

    const client = await ClientLinkedIn.getById(client_id);
    if (!client) return res.status(404).json({ error: "Client not found" });

    res.status(200).json(client);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Update a LinkedIn client
router.put("/client/channel/linkedin/update", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    const updatedClientId = await ClientLinkedIn.update(req.body);
    res.status(200).json({
      message: "Client updated successfully",
      client_id: updatedClientId,
    });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Delete a LinkedIn client
router.delete("/client/channel/linkedin/:id", auth, async (req, res) => {
  try {
    await ClientLinkedIn.delete(parseInt(req.params.id));
    res.status(200).json({ message: "Client deleted successfully" });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

module.exports = router;
