const express = require("express");
const router = express.Router();
const ClientInsta = require("../../models/sales_chanels/clientInsta");
const auth = require("../../middleware/auth");

// 🟢 Create a new client-sales channel relation
router.post("/client/channel/insta/create", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    if (!client_id || typeof client_id !== "number") {
      return res
        .status(400)
        .json({ error: "client_id must be a valid integer" });
    }

    const newClientId = await ClientInsta.create(req.body);
    res
      .status(201)
      .json({ message: "Client created successfully", client_id: newClientId });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get all clients
router.get("/client/channel/insta/all", auth, async (req, res) => {
  try {
    const clients = await ClientInsta.getAll();
    res.status(200).json(clients);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Get a client by ID
router.get("/client/channel/insta/:id", auth, async (req, res) => {
  try {
    const client_id = parseInt(req.params.id);
    if (isNaN(client_id)) {
      return res.status(400).json({ error: "Invalid client_id" });
    }

    const client = await ClientInsta.getById(client_id);
    if (!client) return res.status(404).json({ error: "Client not found" });

    res.status(200).json(client);
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Update a client record
router.put("/client/channel/insta/update", auth, async (req, res) => {
  try {
    const { client_id } = req.body;
    if (!client_id || typeof client_id !== "number") {
      return res
        .status(400)
        .json({ error: "client_id must be a valid integer" });
    }

    const updatedClientId = await ClientInsta.update(req.body);
    res.status(200).json({
      message: "Client updated successfully",
      client_id: updatedClientId,
    });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

// 🟢 Delete a client record
router.delete("/client/channel/insta/:id", auth, async (req, res) => {
  try {
    const client_id = parseInt(req.params.id);
    if (isNaN(client_id)) {
      return res.status(400).json({ error: "Invalid client_id" });
    }

    await ClientInsta.delete(client_id);
    res.status(200).json({ message: "Client deleted successfully" });
  } catch (error) {
    res.status(500).json({ error: "Internal Server Error" });
  }
});

module.exports = router;
