const express = require("express");
const CountryRegion = require("../models/countryRegion");
const auth = require("../middleware/auth");

const router = express.Router();

// Get all countries
router.get("/countries", auth, async (req, res) => {
  try {
    const countries = await CountryRegion.getAll();
    res.json(countries);
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error fetching countries", error: err.message });
  }
});

// Get regions by country_id
router.get("/regions/:country_id", auth, async (req, res) => {
  try {
    const regions = await CountryRegion.getById(req.params.country_id);
    if (!regions) return res.status(404).json({ message: "Regions not found" });
    res.json(regions);
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error fetching Regions", error: err.message });
  }
});

module.exports = router;
