const { super_admin, client, user } = require("./constantRoutes");
const authMiddleware = (req, res, next) => {
  try {
    if (!req.user || !req.user.role) {
      return res.status(403).json({ message: "Access denied. No role found." });
    }

    const allowedRoutes = {
      super_admin: super_admin,
      client: client,
      user: user,
    };

    const userRole = req.user.role;
    const requestPath = req.path;

    const isAllowed = allowedRoutes[userRole]?.some((route) =>
      typeof route === "string"
        ? route === requestPath
        : route.test(requestPath)
    );

    if (!isAllowed) {
      return res
        .status(403)
        .json({ message: "Access denied. Unauthorized role." });
    }

    next();
  } catch (error) {
    res
      .status(500)
      .json({ message: "Internal server error", error: error.message });
  }
};

module.exports = { default: authMiddleware };
