require("dotenv").config();
const express = require("express");
const cors = require("cors");
const authRoutes = require("./routes/auth");
const vendorRoutes = require("./routes/client");
const clientLocationRoutes = require("./routes/clientLocationRoute");
const clientUsersRoutes = require("./routes/clientUsers");
const countryRegion = require("./routes/countryRegion");
const masterSalesChannel = require("./routes/sales_chanels/masterSalesChannel");
const masterShippingMethod = require("./routes/shipping_methods/masterShippingMethod");
const masterPaymentGateway = require("./routes/payment_gateways/masterPaymentGateway");
const clientAmazon = require("./routes/sales_chanels/clientAmazon");
const clientAmazonIndia = require("./routes/sales_chanels/clientAmazonIndia");
const clientFacebook = require("./routes/sales_chanels/clientFacebook");
const clientInsta = require("./routes/sales_chanels/clientInsta");
const clientTwitter = require("./routes/sales_chanels/clientTwitter");
const clientTumblr = require("./routes/sales_chanels/clientTumblr");
const clientLinkedin = require("./routes/sales_chanels/clientLinkedin");
// const masterSalesChannelData = require("./models/sales_chanels/clientTumblr");
const app = express();
const PORT = process.env.PORT || 5000;

app.use(cors());
app.use(express.json());

// Just doing for creating a table if not exists before starting
// (async () => {
//   await masterSalesChannelData.createTable();
// })();
app.get("/", async (req, res) => {
  try {
    res.send("Backend server is running");
  } catch (error) {
    res.send(error);
  }
});

app.use("/api/auth", authRoutes);
app.use("/api", vendorRoutes);
app.use("/api", clientLocationRoutes);
app.use("/api", clientUsersRoutes);
app.use("/api", countryRegion);
app.use("/api", masterSalesChannel);
app.use("/api", masterShippingMethod);
app.use("/api", masterPaymentGateway);
app.use("/api", clientAmazon);
app.use("/api", clientAmazonIndia);
app.use("/api", clientFacebook);
app.use("/api", clientInsta);
app.use("/api", clientTwitter);
app.use("/api", clientTumblr);
app.use("/api", clientLinkedin);
app.use((req, res, next) => {
  res.setHeader("Access-Control-Allow-Origin", "http://localhost:3000"); // Frontend URL
  res.setHeader("Access-Control-Allow-Credentials", "true"); // Allow credentials
  res.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE"); // Allowed methods
  res.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization"); // Allowed headers
  next();
});
app.use((req, res, next) => {
  res.status(404).send("Route does not match");
});
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
